/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.OccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.SmartHighlightPainter;

class DefaultOccurrenceMarker
implements OccurrenceMarker {
    DefaultOccurrenceMarker() {
    }

    @Override
    public Token getTokenToMark(RSyntaxTextArea textArea) {
        Caret c2;
        int dot;
        int line = textArea.getCaretLineNumber();
        Token tokenList = textArea.getTokenListForLine(line);
        Token t2 = RSyntaxUtilities.getTokenAtOffset(tokenList, dot = (c2 = textArea.getCaret()).getDot());
        if (t2 == null || !this.isValidType(textArea, t2) || RSyntaxUtilities.isNonWordChar(t2)) {
            --dot;
            try {
                if (dot >= textArea.getLineStartOffset(line)) {
                    t2 = RSyntaxUtilities.getTokenAtOffset(tokenList, dot);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        return t2;
    }

    @Override
    public boolean isValidType(RSyntaxTextArea textArea, Token t2) {
        return textArea.getMarkOccurrencesOfTokenType(t2.getType());
    }

    @Override
    public void markOccurrences(RSyntaxDocument doc, Token t2, RSyntaxTextAreaHighlighter h2, SmartHighlightPainter p2) {
        DefaultOccurrenceMarker.markOccurrencesOfToken(doc, t2, h2, p2);
    }

    public static void markOccurrencesOfToken(RSyntaxDocument doc, Token t2, RSyntaxTextAreaHighlighter h2, SmartHighlightPainter p2) {
        char[] lexeme = t2.getLexeme().toCharArray();
        int type = t2.getType();
        int lineCount = doc.getDefaultRootElement().getElementCount();
        for (int i2 = 0; i2 < lineCount; ++i2) {
            for (Token temp = doc.getTokenListForLine(i2); temp != null && temp.isPaintable(); temp = temp.getNextToken()) {
                if (!temp.is(type, lexeme)) continue;
                try {
                    int end = temp.getEndOffset();
                    h2.addMarkedOccurrenceHighlight(temp.getOffset(), end, p2);
                    continue;
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        }
    }
}

